/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminCompleteWorkDialog;
import filenet.vw.toolkit.admin.result.VWAdminConfirmWithCheckBoxDialog;
import filenet.vw.toolkit.admin.result.VWAdminConfirmYesNoCancelDialog;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

public class VWAdminCompleteWork {
    private Vector m_vErrors = new Vector();
    private boolean m_bOverride = false;
    protected VWAdminResultPane m_resultsPane;
    protected VWTable m_resultsTable;
    protected int[] m_selectedRows;
    protected VWAdminResultTableModelBase m_tableModel;
    protected Vector m_wobsList = new Vector();
    protected VWParticipant m_logonUser = null;
    protected Frame m_parentFrame = null;
    protected Container m_mainContainer = null;
    protected ListSelectionModel m_listSelectionModel = null;

    public VWAdminCompleteWork(VWAdminResultPane resultsPane) {
        this.m_resultsPane = resultsPane;
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        this.m_tableModel = this.m_resultsPane.getTableModel();
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        this.m_listSelectionModel = this.m_resultsTable.getSelectionModel();
        this.m_logonUser = this.m_resultsPane.getLogonUser();
        this.m_mainContainer = this.m_resultsPane.getMainContainer();
        this.m_parentFrame = this.m_resultsPane.getParentFrame();
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLogonUser, VWResource.s_completeTitle, 1, null);
            return;
        }
        if (this.m_resultsTable.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_noRowSelected, VWResource.s_completeTitle, 1, null);
            return;
        }
        this.buildWobsList(this.m_selectedRows);
        boolean operationOk = this.isOperationAllowed();
        if (!operationOk) {
            VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_completeTitle, VWResource.s_completeReqMessage, this.m_vErrors);
            dlg.setVisible(true);
            this.removeReferences();
            return;
        }
        boolean bCancel = this.checkForSaveAndOverride(this.m_selectedRows);
        if (bCancel) {
            this.removeReferences();
            return;
        }
        this.doLock(this.m_wobsList);
        this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog errorDlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_completeTitle, VWResource.s_lockErr, this.m_vErrors);
            errorDlg.setVisible(true);
            this.removeReferences();
            return;
        }
        VWAdminCompleteWorkDialog completeDlg = new VWAdminCompleteWorkDialog(this.m_wobsList, this.m_resultsPane);
        completeDlg.setVisible(true);
        this.m_listSelectionModel.clearSelection();
        this.m_tableModel.removeWorkObjectsOutOfTable();
        this.m_tableModel.refreshAllRows();
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_completeTitle, VWResource.s_completeErr, this.m_vErrors);
            dlg.setVisible(true);
        }
        this.removeReferences();
    }

    private void buildWobsList(int[] rows) {
        try {
            for (int i = 0; i < rows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                this.m_wobsList.addElement(woData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean isOperationAllowed() {
        boolean foundResponses = false;
        boolean bUnique = true;
        try {
            VWWorkObject wob;
            VWAdminWorkObjectTableData woData;
            int i;
            for (i = 0; i < this.m_wobsList.size(); ++i) {
                woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                wob = woData.getWob();
                String[] responses = wob.getStepResponses();
                if (responses == null) continue;
                foundResponses = true;
                break;
            }
            if (!foundResponses) {
                return true;
            }
            block3: for (i = 0; i < this.m_wobsList.size(); ++i) {
                woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                wob = woData.getWob();
                String workflowName = wob.getWorkflowName();
                int stepId = wob.getWorkOrderId();
                for (int j = 0; j < this.m_wobsList.size(); ++j) {
                    if (i == j) continue;
                    VWAdminWorkObjectTableData anotherWoData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(j);
                    VWWorkObject anotherWob = anotherWoData.getWob();
                    String anotherWorkflowName = anotherWob.getWorkflowName();
                    int anotherStepId = anotherWob.getWorkOrderId();
                    if (VWStringUtils.compare(workflowName, anotherWorkflowName) != 0) {
                        bUnique = false;
                        continue block3;
                    }
                    if (stepId == anotherStepId) continue;
                    bUnique = false;
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bUnique;
    }

    private boolean checkForSaveAndOverride(int[] rows) {
        boolean bCancel = true;
        boolean bSave = false;
        boolean bLockedByOthers = VWAdminCommon.isAnyLockedByOthers(this.m_wobsList);
        boolean bModified = VWAdminCommon.isAnyWorkModified(this.m_wobsList);
        if (bLockedByOthers || bModified) {
            if (bLockedByOthers && bModified) {
                VWAdminConfirmWithCheckBoxDialog confirmDlg = new VWAdminConfirmWithCheckBoxDialog(this.m_parentFrame, VWResource.s_completeTitle, VWResource.s_confirmSaveMessageBeforeComplete, VWResource.s_override, 0);
                confirmDlg.setVisible(true);
                if (confirmDlg.isCanceled()) {
                    return bCancel;
                }
                this.m_bOverride = confirmDlg.isChecked();
                bSave = confirmDlg.isYes();
            } else if (bLockedByOthers) {
                VWAdminConfirmYesNoCancelDialog dlg = new VWAdminConfirmYesNoCancelDialog(this.m_parentFrame, VWResource.s_completeTitle, VWResource.s_confirmOverride, 0);
                dlg.setVisible(true);
                if (dlg.isCanceled()) {
                    return bCancel;
                }
                this.m_bOverride = dlg.isYes();
                bSave = false;
            } else if (bModified) {
                VWAdminConfirmYesNoCancelDialog saveDlg = new VWAdminConfirmYesNoCancelDialog(this.m_parentFrame, VWResource.s_completeTitle, VWResource.s_confirmSaveMessageBeforeComplete, 0);
                saveDlg.setVisible(true);
                if (saveDlg.isCanceled()) {
                    return bCancel;
                }
                this.m_bOverride = true;
                bSave = saveDlg.isYes();
            }
        } else {
            this.m_bOverride = true;
        }
        if (bSave) {
            this.doSave(this.m_wobsList);
        } else {
            this.doRefresh(this.m_wobsList);
        }
        this.m_tableModel.refreshSelectedRows(rows);
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog errorDlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_completeTitle, VWResource.s_saveErr, this.m_vErrors);
            errorDlg.setVisible(true);
            return bCancel;
        }
        return false;
    }

    private void doRefresh(Vector wobsList) {
        VWAdminWorkObjectTableData woData;
        int i;
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWWorkObject wob = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        for (i = 0; i < wobsList.size(); ++i) {
            woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
            if (woData.getLockedStatus() != 1) continue;
            woVector.addElement(woData.getWob());
        }
        if (woVector.size() != 0) {
            woArray = new VWWorkObject[woVector.size()];
            for (i = 0; i < woVector.size(); ++i) {
                woArray[i] = (VWWorkObject)woVector.elementAt(i);
            }
            for (i = 0; i < woArray.length; ++i) {
                try {
                    wob = woArray[i];
                    wob.doRefresh(true, true);
                    woData = VWAdminCommon.findWoData(wob, wobsList);
                    if (woData == null) continue;
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doSave(Vector wobsList) {
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.getLockedStatus() != 1 || !woData.isDirty()) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doSave(false);
                    wob.doRefresh(true, true);
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i2);
                if (woData.getLockedStatus() != 1 || !woData.isDirty()) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doSaveMany(woArray);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(true, true);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, wobsList);
                        if (woData == null) continue;
                        woData.setDirty(false);
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doLock(Vector wobsList) {
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.getLockedStatus() == 1) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doLock(this.m_bOverride);
                    wob.doRefresh(true, true);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i2);
                int lockedStatus = woData.getLockedStatus();
                if (woData.getLockedStatus() == 1) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doLockMany(woArray, this.m_bOverride);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(true, true);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, wobsList);
                        if (woData == null) continue;
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void removeReferences() {
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
    }
}

